// ===== АНИМАЦИЯ ПОЯВЛЕНИЯ ПРИ СКРОЛЛЕ =====

// Собираем все элементы, которые должны анимироваться
const animatedElements = document.querySelectorAll(
    '.Heading-Second-Block, .Heading-First-Block, ' +
    '.Place-For-Element3, .Place-For-Element4, .Place-For-Element5, ' +
    '.Place-For-Element6, .Place-For-Element7, .Footer, ' +
    '.Card-Of-Second-Block-Left, .Card-Of-Second-Block-Right, ' +
    '.Place-For-Text-Third-Block, ' +
    '.Left-Side-Fourth-Block, .Right-Side-Fourth-Block, ' +
    '.Line-Of-Fifth-Block'
);

// Функция проверки, виден ли элемент в окне просмотра
function isElementInViewport(element) {
    const rect = element.getBoundingClientRect();
    const windowHeight = window.innerHeight || document.documentElement.clientHeight;
    
    // Элемент считается видимым, когда он появился на 15% своей высоты
    const triggerPoint = windowHeight * 0.85;
    
    return (
        rect.top <= triggerPoint &&
        rect.bottom >= 0
    );
}

// Основная функция анимации
function handleScrollAnimation() {
    animatedElements.forEach(element => {
        if (isElementInViewport(element)) {
            element.classList.add('Visible');
        }
    });
}

// Инициализация анимации
document.addEventListener('DOMContentLoaded', () => {
    // Проверяем сразу при загрузке (для элементов, которые уже видны)
    handleScrollAnimation();
    
    // Добавляем обработчик скролла
    window.addEventListener('scroll', handleScrollAnimation);
    
    // Дебаунсинг для оптимизации
    let scrollTimeout;
    window.addEventListener('scroll', () => {
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(handleScrollAnimation, 50);
    });
});

// Анимация для заголовка первого блока (появляется сразу с задержкой)
window.addEventListener('DOMContentLoaded', () => {
    const firstBlockHeading = document.querySelector('.Heading-First-Block');
    if (firstBlockHeading) {
        setTimeout(() => {
            firstBlockHeading.classList.add('Visible');
        }, 400);
    }
});

